/******************************************************************************
 CMenuWindow.c

							The Desktop Class	
 ******************************************************************************/
/*
 * Copyright (C) 1985-1992  New York University
 * Copyright (C) 1994 George Washington University
 * 
 * This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
 * system.  See the Ada/Ed README file for warranty (none) and distribution
 * info and also the GNU General Public License for more details.
 */


#include <CBartender.h>
#include <string.h>
#include <CDesktop.h>

#include "CMenuWindow.h"


static void ChangeCmd(CObject *obj, long param);


extern CBartender	*gBartender;		/* Manages all menus				*/
extern CDesktop		*gDesktop;			/* The enclosure for all windows */


void	CMenuWindow::IWindow(short WINDid, Boolean aFloating,
			CDesktop *anEnclosure, CDirector *aSupervisor)
{

	if (gBartender) {
		MenuHandle menu;

		menuId = 133;
		menu = gBartender->FindMacMenu(menuId);
		menuItem = CountMItems(menu) + 1;
		SetCmdNo(-(((long)menuId) << 16) - menuItem);
	}

	cmdInMenu = false;
	inherited::IWindow(WINDid, aFloating, anEnclosure, aSupervisor);
}

void	CMenuWindow::INewWindow( Rect *bounds, Boolean fVisible, short procID,
			Boolean fFloating, Boolean fHasGoAway,
			CDesktop *anEnclosure, CDirector *aSupervisor)
{
	if (gBartender) {
		MenuHandle menu;

		menuId = 133;
		menu = gBartender->FindMacMenu(menuId);
		menuItem = CountMItems(menu) + 1;
		SetCmdNo(-(((long)menuId) << 16) - menuItem);
	}

	cmdInMenu = false;
	inherited::INewWindow(bounds, fVisible, procID, fFloating, fHasGoAway,
			anEnclosure, aSupervisor);
}

long	CMenuWindow::GetCmdNo(void)
{
	return cmdNo;
}

void	CMenuWindow::SetCmdNo(long command)
{
	cmdNo = command;
}

void	CMenuWindow::Dispose(void)
{
	// Remove before disposing
	if (cmdInMenu)
		RemoveFromMenu();

	inherited::Dispose();
}

void	CMenuWindow::Close(void)
{
	// Remove before closing
	if (cmdInMenu)
		RemoveFromMenu();
	
	inherited::Close();
}

void	CMenuWindow::Show(void)
{
	if (!cmdInMenu)
		AddToMenu();

	inherited::Show();
}

void	CMenuWindow::Select(void)
{
	if (!cmdInMenu)
		AddToMenu();

	inherited::Select();
}

void	CMenuWindow::SetTitle(Str255 theTitle)
{

	inherited::SetTitle(theTitle);

	if (gBartender)
		gBartender->SetCmdText(cmdNo, theTitle);
}


/******************************************************************************
 AddToMenu

		Add a window to the menu
 ******************************************************************************/

void	CMenuWindow::AddToMenu(void)
{
	Str255 wName;

	if (gBartender) {

		GetTitle(wName);		// Add command to menu
		gBartender->InsertMenuCmd(cmdNo, wName, menuId, menuItem);
		cmdInMenu = true;
	}
}
	
/******************************************************************************
 RemoveWind

		Remove a window from the menu
 ******************************************************************************/


	static void ChangeCmd(CObject *obj, long param)
	{
		CMenuWindow *win = (CMenuWindow *)obj;
		
		if (member(obj, CMenuWindow)) {
			long	wMenuCmd = win->GetCmdNo();
			short	wMenuId = HiShort(-wMenuCmd);
			short	wMenuItem = LoShort(-wMenuCmd);
			
			// if menu item in window is larger than menu item
			// being removed... then
			if (wMenuItem > LoShort(-param))
				win->SetCmdNo((-(((long)wMenuId) << 16) - (wMenuItem-1)));
		}
	}


void	CMenuWindow::RemoveFromMenu(void)
{
	if (gBartender) {
		CList *itsList;

		gBartender->RemoveMenuCmd(cmdNo);
		cmdInMenu = false;

		// Search itsWindow list and change the command number to all menu
		// items below the one we are deleting by -1
		gDesktop->itsWindows->DoForEach1(ChangeCmd, cmdNo);
	}
}
